//+------------------------------------------------------------------+
//|                                           Hourly Pivot Point.mq4 |
//|                                                       BurgerKing |
//|                                             www.ForexFactory.com |
//+------------------------------------------------------------------+
#property copyright "BurgerKing"
#property link      "www.ForexFactory.com"

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Lime
#property indicator_color2 Green
#property indicator_color3 DarkGreen
#property indicator_color4 Blue
#property indicator_color5 Maroon
#property indicator_color6 Crimson
#property indicator_color7 Red

//---- buffers
double ChartR3[];
double ChartR2[];
double ChartR1[];
double ChartPP[];
double ChartS1[];
double ChartS2[];
double ChartS3[];

extern string comment2 = "Fibonacci=0, Alexander=1";
extern int Model = 0;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init() {
	//---- indicators
	SetIndexBuffer(0,ChartR3);
	SetIndexBuffer(1,ChartR2);
	SetIndexBuffer(2,ChartR1);
	SetIndexBuffer(3,ChartPP);
	SetIndexBuffer(4,ChartS1);
	SetIndexBuffer(5,ChartS2);
	SetIndexBuffer(6,ChartS3);

	SetIndexStyle(0,DRAW_LINE,STYLE_SOLID);
	SetIndexStyle(1,DRAW_LINE,STYLE_DOT);
	SetIndexStyle(2,DRAW_LINE,STYLE_DOT);
	SetIndexStyle(3,DRAW_LINE,STYLE_SOLID);
	SetIndexStyle(4,DRAW_LINE,STYLE_DOT);
	SetIndexStyle(5,DRAW_LINE,STYLE_DOT);
	SetIndexStyle(6,DRAW_LINE,STYLE_SOLID);

	string short_name = "Daily Pivot Point System v1.1";
	IndicatorShortName(short_name);
	return(1);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit() {
	ObjectDelete("R3");
	ObjectDelete("R2");
	ObjectDelete("R1");
	ObjectDelete("PP");
	ObjectDelete("S1");
	ObjectDelete("S2");
	ObjectDelete("S3");
	Comment("");
	return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

double prevL=0, prevH=0, prevC=0, prevO=0;
double S3, S2, S1, P = 0, R1, R2, R3;
int thisHour = -1;

int start() {
	if (Period() > 60) return(0);		//Chart cannot be higher than H1
	
	int counted_bars=IndicatorCounted();
	if (counted_bars >0) counted_bars--;
	int limit=Bars-counted_bars;

	int period = MathCeil(60 / Period());

	for (int i = limit-1; i>=0; i--) {
		if (i + period < Bars && TimeMinute(iTime(NULL,0,i)) == 0 && thisHour != TimeHour(iTime(NULL,0,i)) ) {
			thisHour = TimeHour(iTime(NULL,0,i));
			prevH = High[Highest(NULL, 0, MODE_HIGH, period, i+1)];
			prevL = Low [Lowest (NULL, 0, MODE_LOW,  period, i+1)];
			prevC = Close[i+1];

			if (Model == 0) {
				double R  = (prevH - prevL);
				P  = (prevH + prevL + prevC)/3;
				R3 = P + (R * 1.000);
				R2 = P + (R * 0.618);
				R1 = P + (R * 0.382);
				S1 = P - (R * 0.382);
				S2 = P - (R * 0.618);
				S3 = P - (R * 1.000);
			} else if (Model == 1) {
				P  = (prevH + prevL + prevC)/3;
				R1 = (2*P)- prevL;
				S1 = (2*P)- prevH;
				R2 = P+(R1-S1);
				S2 = P-(R1-S1);
				R3 = (prevH + (2*(P-prevL)));
				S3 = (prevL - (2*(prevH-P)));
			}
		}

		if (P > 0) {
			ChartR3[i] = R3;
			ChartR2[i] = R2;
			ChartR1[i] = R1;
			ChartPP[i] = P;
			ChartS1[i] = S1;
			ChartS2[i] = S2;
			ChartS3[i] = S3;

			drawLabel("R3",R3,Lime);
			drawLabel("R2",R2,Green);
			drawLabel("R1",R1,DarkGreen);
			drawLabel("PP",P, Blue);
			drawLabel("S1",S1,Maroon);
			drawLabel("S2",S2,Crimson);
			drawLabel("S3",S3,Red);
		}
	}
	return(0);
}

//+------------------------------------------------------------------+

void drawLabel (string name,double lvl,color Color) {
	if (ObjectFind(name) != 0) {
		ObjectCreate(name, OBJ_TEXT, 0, Time[10], lvl);
		ObjectSetText(name, name, 8, "Arial", EMPTY);
		ObjectSet(name, OBJPROP_COLOR, Color);
	} else {
		int x = 1 + MathCeil(10/Period());
		ObjectMove(name, 0, Time[x], lvl);
	}
}

